<?php
/* --------------------------------------------------------------
   LooseFilters.php 2020-10-19
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Filter;

use Webmozart\Assert\Assert;

/**
 * Class LooseFilters
 *
 * @package Gambio\Core\Filter
 */
class LooseFilters implements Filters
{
    /**
     * @var Filter[]
     */
    protected $filters;
    
    
    /**
     * LooseFilters constructor.
     *
     * @param Filter ...$filters
     */
    protected function __construct(Filter ...$filters)
    {
        $this->filters = $filters;
    }
    
    
    /**
     * @param Filter ...$filters
     *
     * @return static
     */
    public static function create(Filter ...$filters)
    {
        return new static(...$filters);
    }
    
    
    /**
     * @param array $filterMap
     *
     * @return static
     */
    public static function createFromMap(array $filterMap)
    {
        Assert::isMap($filterMap, 'Provided filters array need to be a map.');
        Assert::allRegex($filterMap,
                         self::OPERATION_AND_VALUE_STRING_PATTERN,
                         'Provided filtern don\'t match expected pattern: ' . self::OPERATION_AND_VALUE_STRING_PATTERN);
        
        $filters = [];
        foreach ($filterMap as $attribute => $filter) {
            $value     = $filter;
            $operation = (strpos($value, '*') !== false) ? 'like' : 'eq';
            if (strpos($filter, '|') !== false) {
                $value     = substr($filter, strpos($filter, '|') + 1);
                $operation = substr($filter, 0, strpos($filter, '|'));
            }
            
            $filters[] = LooseFilter::create($attribute, $operation, $value);
        }
        
        return static::create(...$filters);
    }
    
    
    /**
     * @inheritDoc
     */
    public function filters(): array
    {
        return $this->filters;
    }
}